<?php
/**
 * Module Name: LearnDash Integration
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

if ( function_exists( 'sfwd_lms_has_access' ) ) :

 //*************** Actions ***************\\
 add_action('learndash_completed', 'wpachievements_ld_quiz_complete', 10, 1);
 add_action('learndash_quiz_completed', 'wpachievements_ld_quiz_complete', 10, 1);
 add_action('learndash_lesson_completed', 'wpachievements_ld_lesson_complete', 10, 1);
 add_action('learndash_course_completed', 'wpachievements_ld_course_complete', 10, 1);
 //*************** Detect Quiz Completed ***************\\
 function wpachievements_ld_quiz_complete($quiz){
   if(!empty($quiz)){
     $current_user = wp_get_current_user();
     if( isset($quiz['pro_quizid']) ){
       $postid=$quiz['pro_quizid'];
     } else{
       $postid=$quiz['quiz']->ID;
     }
     if($quiz['pass'] == '1'){
       if($quiz['score'] == $quiz['count']){
        WPAchievements_Trigger::new_activity( array(
          'activity'    => 'ld_quiz_perfect',
          'user_id'     => $current_user->ID,
          'post_id'     => $postid,
          'points'      => (int) wpachievements_get_site_option('wpachievements_ld_quiz_perfect'),
        ) );         
       }
        WPAchievements_Trigger::new_activity( array(
          'activity'    => 'ld_quiz_pass',
          'user_id'     => $current_user->ID,
          'post_id'     => $postid,
          'points'      => (int) wpachievements_get_site_option('wpachievements_ld_quiz_pass'),
        ) );
     } else{
        WPAchievements_Trigger::new_activity( array(
          'activity'    => 'ld_quiz_fail',
          'user_id'     => $current_user->ID,
          'post_id'     => $postid,
          'points'      => -(int) wpachievements_get_site_option('wpachievements_ld_quiz_fail'),
        ) );       
     }
   }
 }
 //*************** Detect Lesson Completed ***************\\
 function wpachievements_ld_lesson_complete($lesson){
   if(!empty($lesson)){
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'ld_lesson_complete',
      'user_id'     => $lesson['user']->data->ID,
      'post_id'     => $lesson['lesson']->ID,
      'points'      => (int) wpachievements_get_site_option('wpachievements_ld_lesson_complete'),
    ) );    
   }
 }
 //*************** Detect Course Completed ***************\\
 function wpachievements_ld_course_complete($course){
   if(!empty($course)){
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'ld_course_complete',
      'user_id'     => $course['user']->data->ID,
      'post_id'     => $course['course']->ID,
      'points'      => (int) wpachievements_get_site_option('wpachievements_ld_course_complete'),
    ) );        
   }
 }

  /**
   * Check if we have a valid activity
   *
   * @param   bool $proceed True on valid activity
   * @param   string $type
   * @param   int $uid
   * @param   int $postid
   * @param   int $ach_ID
   * @return  bool
   */
  function wpachievements_ld_check_actvity( $proceed, $type, $ach_ID, $postid, $uid ) {
    global $wpdb;

    if ( 'ld_quiz_perfect' == $type ) {
      $ach_first_try_only = get_post_meta( $ach_ID, '_achievement_ld_first_attempt_only', true );

      if ( strtolower( $ach_first_try_only ) == 'enabled' ) {
        $attempt_count = $wpdb->get_var( $wpdb->prepare("SELECT COUNT(type) FROM ".WPAchievements()->get_table()." WHERE (type='ld_quiz_pass' OR type='ld_quiz_fail' OR type='ld_quiz_perfect') AND uid=%d AND postid='%d'", $uid,$postid) );

        if ( intval( $attempt_count ) > 1 ) {
          $proceed = false;
        }
      }
    }

    return $proceed;
  }
  add_filter( 'wpachievements_proceed_new_activity', 'wpachievements_ld_check_actvity', 10, 5 );

 //*************** Descriptions ***************\\
 add_filter('wpachievements_activity_description', 'achievement_ld_desc', 10, 4);
 function achievement_ld_desc($text='',$type='',$points='',$times=''){
  switch($type){
   case 'ld_quiz_pass': { $text = sprintf( _n( 'for passing %s quiz', 'for passing %s quizzes', $times, 'wpachievements' ), $times ); } break;
   case 'ld_quiz_fail': { $text = sprintf( _n( 'for failing %s quiz', 'for failing %s quizzes', $times, 'wpachievements' ), $times ); } break;
   case 'ld_quiz_perfect': { $text = sprintf( _n( 'for getting %s perfect score', 'for getting %s perfect scores', $times, 'wpachievements' ), $times ); } break;
   case 'ld_lesson_complete': { $text = sprintf( _n( 'for completing %s lesson', 'for completing %s lessons', $times, 'wpachievements' ), $times ); } break;
   case 'ld_course_complete': { $text = sprintf( _n( 'for completing %s course', 'for completing %s courses', $times, 'wpachievements' ), $times ); } break;
  }
  return $text;
}

 //*************** Descriptions ***************\\
 add_filter('wpachievements_quest_description', 'quest_ld_desc', 10, 3);
 function quest_ld_desc($text='',$type='',$times=''){
  switch($type){
   case 'ld_quiz_pass': { $text = sprintf( _n( 'Pass %s quiz', 'Pass %s quizzes', $times, 'wpachievements' ), $times ); } break;
   case 'ld_quiz_fail': { $text = sprintf( _n( 'Fail %s quiz', 'Fail %s quizzes', $times, 'wpachievements' ), $times ); } break;
   case 'ld_quiz_perfect': { $text = sprintf( _n( 'Get %s perfect score', 'Get %s perfect scores', $times, 'wpachievements' ), $times ); } break;
   case 'ld_lesson_complete': { $text = sprintf( _n( 'Complete %s lesson', 'Complete %s lessons', $times, 'wpachievements' ), $times ); } break;
   case 'ld_course_complete': { $text = sprintf( _n( 'Complete %s course', 'Complete %s courses', $times, 'wpachievements' ), $times ); } break;
  }
  return $text;
 }

add_filter( 'wpachievements_get_sections_module', 'wpachievements_add_section_ld' );
function wpachievements_add_section_ld( $sections ) {
	$sections['ld'] = __( 'LearnDash', 'wpachievements' );
	return $sections;
}

//*************** Admin Settings ***************\\
add_filter('wpachievements_achievements_modules_admin_settings', 'wpachievements_ld_admin', 10, 3);
function wpachievements_ld_admin($defaultsettings, $shortname, $current_section){
  if ( $current_section == 'ld' ) {
    $settings[] = array( 'title' => __( 'LearnDash', 'wpachievements' ), 'type' => 'title', 'desc' => '', 'id' => 'LearnDash_options' );

    $settings[] = array(
            'title'   => __( 'User Passes Quiz', 'wpachievements' ),
            'desc'    => __( 'Points awarded when a user passes a quiz.', 'wpachievements' ),
            'id'      => $shortname.'_ld_quiz_pass',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'User Fails Quiz', 'wpachievements' ),
            'desc'    => __( 'Points awarded when a user fails a quiz.', 'wpachievements' ),
            'id'      => $shortname.'_ld_quiz_fail',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'User Gets Perfect Quiz Score', 'wpachievements' ),
            'desc'    => __( 'Points awarded when a user gets 100% on a quiz.', 'wpachievements' ),
            'id'      => $shortname.'_ld_quiz_perfect',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'User Completes Lesson', 'wpachievements' ),
            'desc'    => __( 'Points awarded when a user completes a lesson.', 'wpachievements' ),
            'id'      => $shortname.'_ld_lesson_complete',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'Users Completes Course.', 'wpachievements' ),
            'desc'    => __( 'Points awarded when a user completes a course.', 'wpachievements' ),
            'id'      => $shortname.'_ld_course_complete',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array( 'type' => 'sectionend', 'id' => 'LearnDash_options');

    return $settings;
  /**
  * If not, return the standard settings
  **/
	} else {
		return $defaultsettings;
	}
}

 //*************** Admin Events ***************\\
 add_filter('wpachievements_admin_events', 'achievement_ld_admin_events', 10);
 function achievement_ld_admin_events(){
   echo'<optgroup label="LearnDash Events">
     <option value="ld_quiz_pass">'.__('The user passes a quiz', 'wpachievements').'</option>
     <option value="ld_quiz_fail">'.__('The user fails a quiz', 'wpachievements').'</option>
     <option value="ld_quiz_perfect">'.__('The user gets 100% on a quiz', 'wpachievements').'</option>
     <option value="ld_lesson_complete">'.__('The user completes a lesson', 'wpachievements').'</option>
     <option value="ld_course_complete">'.__('The user completes a course', 'wpachievements').'</option>
   </optgroup>';
 }

 //*************** Admin Trigger Naming ***************\\
 add_filter('wpachievements_trigger_description', 'achievement_ld_admin_triggers', 1, 10);
 function achievement_ld_admin_triggers($trigger){

   switch($trigger){
     case 'ld_quiz_pass': { $trigger = __('The user passes a quiz', 'wpachievements'); } break;
     case 'ld_quiz_fail': { $trigger = __('The user fails a quiz', 'wpachievements'); } break;
     case 'ld_quiz_perfect': { $trigger = __('The user gets 100% on a quiz', 'wpachievements'); } break;
     case 'ld_lesson_complete': { $trigger = __('The user completes a lesson', 'wpachievements'); } break;
     case 'ld_course_complete': { $trigger = __('The user completes a course', 'wpachievements'); } break;
   }

   return $trigger;
 }
endif;
?>